; PRisme Monitor Library
; Version 0.99
; (c) 2005 by Freddy


; *** Constants and Definitions ***

;.equ	baud	= 19200			; UART BaudRate slow transmission (comment other out)
.equ	baud	= 38400			; UART BaudRAte fast transmission (comment other out)
.equ	_UBRR	= clock/(16*baud)-1

.equ	SecByte = 0	; Second Byte expected
;.equ	reserved= 1	; not in use
;.equ	reserved= 2	; not in use
;.equ	reserved= 3	; not in use
;.equ	reserved= 4	; not in use
;.equ	reserved= 5	; not in use
;.equ	reserved= 6	; not in use
;.equ	reserved= 7	; not in use


; *** SRAM initialisation ***

.dseg					; 125 bytes
.org	0x60				; start at SRAM origin
data0:	.byte	1			; Data Memory passed to C++ Application
data1:	.byte	1
data2:	.byte	1
data3:	.byte	1
data4:	.byte	1
data5:	.byte	1
data6:	.byte	1
data7:	.byte	1
data8:	.byte	1
data9:	.byte	1

mSREG:	.byte	1			; KEEP IN PLACE, is being sent as eleventh data segment

gauge1:	.byte	1			; analog gauges
gauge2:	.byte	1
gauge3:	.byte	1

slider1:.byte	1			; slidebar values
slider2:.byte	1
slider3:.byte	1

LinCam:	.byte	102			; Linear Camera data
LCmean:	.byte	1			; Linear Camera mean value

UARTFlg:.byte	1			; UART Flags
TxPoint:.byte	1			; UART Tx Data Pointer (from Base)
TxEnd:	.byte	1			; UART Tx Data End

MemSet:	.byte	1			; Offset position to store received byte
.cseg

monitor_init:
	clr	_w			; prepare "zero" register
	clr	w			; clear loop counter
	ldi	yl, low(data0)
	ldi	yh,high(data0)		; load SRAM entrypoint
m_ini_1:st	Y+,_w			; clear SRAM Data
	inc	w			; increment loop counter
	cpi	w,0x77
	breq	m_ini_2			; if w == 119 then leave
	rjmp	m_ini_1			; else send next value

m_ini_2:sei				; enable global Interupt Flag
	;ret				; fall through to UART init


; *** UART Control and Subroutines ***

UART_init:
	ldi	w, _UBRR
	out	UBRR,w			; set Baud rate
	ldi	w,(1<<TXEN)+(1<<RXEN)+(1<<RXCIE)+(0<<UDRIE)
	out	UCSRB,w			; Transmit/Receive Enable, Receive Interrupt Enable, Data Reg Empty Disable
	ldi	w,(1<<URSEL)+(3<<UCSZ0)
	out	UCSRC,w			; set frame format: 8data, no-parity, 1stop
	ret

UART_putc:	
	sbis	UCSRA,UDRE		; wait for UART Date Register Empty
	rjmp	PC-1			; loop back if not empty
	out	UDR,w			; output character to UART Data Register
	ret
	

; *** UART receive complete Interrupt Service Routine ***
UART_rxc:
	in	_sreg,SREG
	push	w
	PUSHZ				; save context

	in	_w,UDR			; read character from UART Data Register
	lds	w,UARTFlg		; load flags
	sbrc	w,SecByte		; Second Byte?
	rjmp	ur_2			; jump ahead to store second byte

ur_0:	dec	_w			; compensate for ONE offset
	cpi	_w,0x63			; >= 99 ?
	brge	ur_1
	LOOKUP2	zh,zl,_w,command	; get corresponding call address
	icall				; execute command
	rjmp	ur_done			; leave interrupt routine

ur_1:	subi	_w,0x64			; subtract 100 offset
	sts	MemSet,_w		; store Memory Offset
	ori	w,(1<<SecByte)		; set Second Byte Flag
	sts	UARTFlg,w		; store flags
	rjmp	ur_done			; leave interrupt routine

ur_2:	
	ldi	zl, low(slider1)
	ldi	zh,high(slider1)	; load SRAM entrypoint
	lds	_u,MemSet		; load Memory Offset
	add	zl,_u
	sbci	zh,-0x00		; increment to corresponding memory
	st	Z,_w			; store data
	andi	w,~(1<<SecByte)		; clear Second Byte Flag
	sts	UARTFlg,w		; store flags
;	rjmp	ur_done			; leave interrupt routine
	
ur_done:POPZ
	pop	w
	out	SREG,_sreg		; restore context
	reti

; *** UART data register empty Interrupt Service Routine ***
UART_dre:
	in	_sreg,SREG
	PUSHY

ud_1:	ldi	yl, low(data0)
	ldi	yh,high(data0)		; load SRAM entrypoint
	lds	_u,TxPoint		; load SRAM Base Offset
	add	yl,_u
	sbci	yh,-0x00		; increment to corresponding memory
	
	inc	_u
	sts	TxPoint,_u		; increment Base Offset
	lds	_w,TxEnd		; load end of Transmission Buffer
	cp	_u,_w			; compare with end of Transmission Buffer
	breq	ud_2			; end transmission

	ld	_w,Y			; load data from SRAM
	out	UDR,_W			; transmit data

	rjmp	ud_done			; leave interrupt	

ud_2:	ldi	_w,(1<<TXEN)+(1<<RXEN)+(1<<RXCIE)+(0<<UDRIE)
	out	UCSRB,_w		; Transmit/Receive Enable, Receive Interrupt Enable, Data Reg Empty Disable
	rcall	m_Port			; transmit Port Status

ud_done:POPY
	out	SREG,_sreg		; restore context
	reti


; *** Monitor Subroutines ***

m_update:
	ldi	w,0x00			; start with first SRAM data
	sts	TxPoint,w		; load SRAM Base Start Offset
	ldi	w,0x0f			; 15 --> 14 bytes starting from Base to send
	sts	TxEnd,w			; load End Offset

	ldi	w,(1<<TXEN)+(1<<RXEN)+(1<<RXCIE)+(1<<UDRIE)
	out	UCSRB,w			; Transmit/Receive Enable, Receive Interrupt Enable, Data Reg Empty Enable
	ldi	w,0xff			; load Data Header SRAM-Data (255)
	out	UDR,w			; initiate transfer

m_u_d:	ret


m_LinCam:
	ldi	w,0x11			; start with LinCam data
	sts	TxPoint,w		; load SRAM Base Start Offset
	ldi	w,0x78			; 120 --> 119 bytes starting from Base to send
	sts	TxEnd,w			; load End Offset

	ldi	w,(1<<TXEN)+(1<<RXEN)+(1<<RXCIE)+(1<<UDRIE)
	out	UCSRB,w			; Transmit/Receive Enable, Receive Interrupt Enable, Data Reg Empty Enable
	ldi	w,0xfe			; load Data Header LinCam (254)
	out	UDR,w			; initiate transfer

m_LC_d:ret


m_Port:
m_P_A:	in	w,PortA			; read Port Status
	rcall	UART_putc		; send Data
	in	w,DDRA			; read Port Status
	rcall	UART_putc		; send Data
	in	w,PinA			; read Port Status
	rcall	UART_putc		; send Data

m_P_B:	in	w,PortB			; read Port Status
	rcall	UART_putc		; send Data
	in	w,DDRB			; read Port Status
	rcall	UART_putc		; send Data
	in	w,PinB			; read Port Status
	rcall	UART_putc		; send Data

m_P_C:	in	w,PortC			; read Port Status
	rcall	UART_putc		; send Data
	in	w,DDRC			; read Port Status
	rcall	UART_putc		; send Data
	in	w,PinC			; read Port Status
	rcall	UART_putc		; send Data

m_P_D:	in	w,PortD			; read Port Status
	rcall	UART_putc		; send Data
	in	w,DDRD			; read Port Status
	rcall	UART_putc		; send Data
	in	w,PinD			; read Port Status
	rcall	UART_putc		; send Data

m_P_dn:	ret


; *** Monitor Macros ***

.macro	M_SREG				; monitors SREG at called position (no args)
	in	w,SREG			; read SREG
	sts	mSREG,w			; store Data
.endmacro


; *** sub-routine includes ***

.include	"command.asm"


; *** lookup tables ***

command:				; command branch table
.dw	comm1,comm2,comm3,comm4,comm5,m_update,m_LinCam

